(function( $ ) {
    'use strict';
    var VisualFloatingHeartAnimation = {
        initFloatingHeart: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualFloatingHeartAnimation.initFloatingHeartWidget);
        },
        initFloatingHeartWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var floatingHeartAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        floatingHeartAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                floatingHeartAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }
                    if(floatingHeartAnimationArgs.marvy_enable_floating_heart_animation) {
                        settings.switch = floatingHeartAnimationArgs.marvy_enable_floating_heart_animation;
                        settings.color1 = floatingHeartAnimationArgs.marvy_floating_heart_animation_color_1;
                        settings.color2 = floatingHeartAnimationArgs.marvy_floating_heart_animation_color_2;
                        settings.color3 = floatingHeartAnimationArgs.marvy_floating_heart_animation_color_3;
                        settings.color4 = floatingHeartAnimationArgs.marvy_floating_heart_animation_color_4;
                        settings.from_degree = floatingHeartAnimationArgs.marvy_floating_heart_animation_from_degree.size;
                        settings.to_degree = floatingHeartAnimationArgs.marvy_floating_heart_animation_to_degree.size;
                        settings.box_shadow_horizontal = floatingHeartAnimationArgs.marvy_floating_heart_animation_box_shadow_horizontal.size;
                        settings.box_shadow_vertical = floatingHeartAnimationArgs.marvy_floating_heart_animation_box_shadow_vertical.size;
                        settings.box_shadow_blur = floatingHeartAnimationArgs.marvy_floating_heart_animation_box_shadow_blur.size;
                        settings.heart_size = floatingHeartAnimationArgs.marvy_floating_heart_animation_heart_size;
                        settings.animation_delay = floatingHeartAnimationArgs.marvy_floating_heart_animation_animation_delay;
                        settings.square_count = floatingHeartAnimationArgs.marvy_floating_heart_animation_square_count;
                        settings.square_size = floatingHeartAnimationArgs.marvy_floating_heart_animation_square_size;
                    }
                });

            } else {
                settings.switch = $scope.data("marvy_enable_floating_heart_animation");
                settings.color1 = $scope.data("marvy_floating_heart_animation_color_1");
                settings.color2 = $scope.data("marvy_floating_heart_animation_color_2");
                settings.color3 = $scope.data("marvy_floating_heart_animation_color_3");
                settings.color4 = $scope.data("marvy_floating_heart_animation_color_4");
                settings.from_degree = $scope.data("marvy_floating_heart_animation_from_degree");
                settings.to_degree = $scope.data("marvy_floating_heart_animation_to_degree");
                settings.box_shadow_horizontal = $scope.data("marvy_floating_heart_animation_box_shadow_horizontal");
                settings.box_shadow_vertical = $scope.data("marvy_floating_heart_animation_box_shadow_vertical");
                settings.box_shadow_blur = $scope.data("marvy_floating_heart_animation_box_shadow_blur");
                settings.heart_size = $scope.data("marvy_floating_heart_animation_heart_size");
                settings.animation_delay = $scope.data("marvy_floating_heart_animation_animation_delay");
                settings.square_count = $scope.data("marvy_floating_heart_animation_square_count");
                settings.square_size = $scope.data("marvy_floating_heart_animation_square_size");
            }
            if (settings.switch) {
                floatingHeartAnimation(target, settings, sectionId);
            } else {
                document.querySelector(target).classList.remove("marvy-custom-floating-heart-animation");
            }
        }
    };

    function floatingHeartAnimation(target,settings,sectionId) {
        var checkElement = document.getElementsByClassName("marvy-floating-heart-section-" + sectionId);
        if (checkElement.length >= 0 && settings) {
            document.querySelector(target).classList.add("marvy-custom-floating-heart-animation-section-" + sectionId);
            document.querySelector(target).classList.add("marvy-custom-floating-heart-animation");
            var floating_heart_div = document.createElement('css-doodle');
            floating_heart_div.append(`--color: @p(${settings.color1}, ${settings.color2}, ${settings.color3}, ${settings.color4});
                                            :doodle {
                                            @grid: ${settings.square_count}x1 / ${settings.square_size}vmin;
                                                --deg: @p(${settings.from_degree}deg, ${settings.to_degree}deg);
                                            }
                                            :container {
                                                perspective: 30vmin;
                                            }
                                            :after, :before {
                                                content: '';
                                                background: var(--color);
                                                @place-cell: @r(100%) @r(100%);
                                                @size: @r(${settings.heart_size}px);
                                                @shape: heart;
                                            }
                                            @place-cell: center;
                                            @size: 100%;
                                            @keyframes scale-up {
                                                0%, 95.01%, 100% {
                                                    transform: translateZ(0) rotate(0);
                                                    opacity: 0;
                                                }
                                                10% {
                                                    opacity: 1;
                                                }
                                                95% {
                                                    transform: translateZ(35vmin) rotateZ(@var(--deg));
                                                }
                                            }
                                            box-shadow: @m2(${settings.box_shadow_horizontal}px ${settings.box_shadow_vertical}px ${settings.box_shadow_blur}px var(--color));
                                            background: @m100(
                                                radial-gradient(var(--color) 50%, transparent 0)
                                                @r(-20%, 120%) @r(-20%, 100%) / 1px 1px
                                                no-repeat
                                            );
                                            will-change: transform, opacity;
                                            animation: scale-up ${settings.animation_delay}s linear infinite;
                                            animation-delay: calc(-12s / @size() * @i());`);

            floating_heart_div.classList.add("marvy-floating-heart-section-" + sectionId);
            floating_heart_div.style.position = "absolute";

            document.querySelector(target).appendChild(floating_heart_div);

            // Set Z-index for section container
            var flotingHeartZindex = document.querySelector('.marvy-custom-floating-heart-animation-section-'+sectionId+' .elementor-container');
            flotingHeartZindex.style.zIndex = '99';
            flotingHeartZindex.style.width = '100%';

        }
        return true;
    }

    $( window ).on('elementor/frontend/init', VisualFloatingHeartAnimation.initFloatingHeart);
})( jQuery );
// Do not formate this code, if you do it may be stop working